define(['angular', 'app'], function (angular, app) {
	'use strict';

	app.controller('AuthenticatedUserController', function ($scope, globalDelayTracker, focusService, $window, $timeout,
        modalService, formatter, HomePageConstants, WeeklyGoalsService, GoalGraphService, FitnessService,
        GoalGraphAccessibilityService, NotificationsPreferencesService) {

        var goalService = WeeklyGoalsService.instance();
		NotificationsPreferencesService.getNotificationsPreferenceAndCount();

		$scope.details = {};
		$scope.globalDelayTracker = globalDelayTracker;
		focusService.focusMain();
		$scope.today = new Date();
		$scope.notificationsDataPointers = NotificationsPreferencesService.dataPointers;
		$scope.activeSlides = [true, false, false];
		$scope.isPhoneView = $window.innerWidth < 768;


		$scope.openGoalsModal = function () {
			FitnessService.openGoalsModal($scope.details).then(function (details) {
				goalService.save(details).then(function () {
				    setDetails(true);
				})
			}).finally(function () {
				focusService.focusElement(angular.element('button[ng-click="openGoalsModal()"]'));
			});
		};

		function setDetails(fetchNew) {
		    if (goalService.dataPointers.list.length === 0) {
		        $scope.details = goalService.createEmpty();
		        if (!goalService.promptedSession) {
		            goalService.promptedSession = true;
		            $scope.openGoalsInfoModal();
		        }
		    } else {
		        $scope.details = goalService.dataPointers.list[0];
				if (fetchNew) {
					fetchGoals();
				}
		    }

		    $scope.goalGraphConfig = GoalGraphService.getGraphConfig($scope.details);
            $scope.screenReaderText = GoalGraphAccessibilityService.getScreenReaderTexts($scope.details);
		}

		$scope.openGoalsInfoModal = function () {
			var modalContent = {
				closeButtonText: 'No',
				actionButtonText: 'Yes',
				headerText: 'Welcome to VA FitHeart',
				bodyText: 'One of the most important parts of staying healthy is being active. You can get started by setting a weekly activity goal. Would you like to set a goal now?'
			};

			modalService.showModal({}, modalContent).then(function () {
				$scope.openGoalsModal();
			}, function () {
				focusService.focusMain();
			});
		};

		if (!navigator.userAgent.match(/(iPad|iPhone|iPod)/g)) {
			angular.element($window).bind('resize.homeGraphResize', function() {
				$timeout(function() {
					angular.forEach(Highcharts.charts, function (chart) {
						if (chart) {
							chart.setSize(chart.chartWidth, chart.chartHeight, false);
						}
					});
				});
			});

			$scope.$on("$destroy",function (){
				$(window).off("resize.homeGraphResize");
			});
		}

		function fetchGoals() {
			goalService.fetch().then(function () {
				setDetails();
			});
		}
		fetchGoals();
	});
});